<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="SHORTCUT ICON" href="https://cdn.prod.website-files.com/63d7e3a7de2c90590f9c535d/65e05551b1ca1d1a5db25de7_favicon-32x32.ico">
    <title>Relay Pay</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f0f4f8;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #333;
        }

        .container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 400px;
            width: 100%;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .container:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
        }

        h1 {
            font-size: 26px;
            color: #4C6EF5;
            margin-bottom: 20px;
        }

        p {
            font-size: 18px;
            margin-bottom: 10px;
            color: #555;
        }

        label {
            font-size: 18px;
            margin-bottom: 10px;
            display: block;
            color: #666;
        }

        input {
            width: 100%;
            padding: 12px;
            margin: 10px 0 25px 0;
            font-size: 18px;
            border: 2px solid #ddd;
            border-radius: 6px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }

        input:focus {
            border-color: #4C6EF5;
            outline: none;
        }

        button {
            background-color: #6F42C1;
            color: white;
            padding: 16px 30px;
            font-size: 18px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            width: 100%;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #5a2d91;
        }

        footer {
            margin-top: 30px;
            font-size: 14px;
            color: #888;
        }

        footer a {
            color: #6F42C1;
            text-decoration: none;
            font-weight: bold;
        }

        footer a:hover {
            text-decoration: underline;
        }

        .go-back-btn {
            background-color: #ff6f61;
            color: white;
            padding: 12px 25px;
            font-size: 18px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            width: 100%;
            transition: background-color 0.3s ease;
            margin-top: 20px;
        }

        .go-back-btn:hover {
            background-color: #e55b51;
        }

        select {
            width: 100%;
            padding: 12px;
            font-size: 18px;
            border: 2px solid #ddd;
            border-radius: 6px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
            margin: 10px 0 25px 0;
        }

        select:focus {
            border-color: #4C6EF5;
            outline: none;
        }

        #usdt-network {
            display: none;
        }

    </style>
</head>
<body>
    <div class="container">
        <img width="300" height="250" src="https://australianfintech.com.au/wp-content/uploads/sites/7/2020/11/RelayPay-Logo2.png"><br>
        <h1>Secure & Easy Payments</h1>
        <p>Pay safely and quickly in just a few clicks.<br>Enter the amount below to get started.<br><br></p>
        <form id="cryptoForm">
            <label for="amount"><b>Enter Amount (Min. $100):</b></label>
            <input type="number" name="amount" id="amount" min="100" required oninput="updateAmountMessage()">
            <br><br>
            <label for="currency">Select Cryptocurrency:</label>
            <select name="currency" id="currency" onchange="toggleNetworkOptions()">
                <option value="BTC">Bitcoin (BTC)</option>
                <option value="ETH">Ethereum (ETH)</option>
                <option value="USDT">Tether (USDT)</option>
                <option value="USDC">USDC (USD Coin)</option>
                <option value="SOL">Solana (SOL)</option>
                <option value="BNB">Binance Coin (BNB)</option>
                <option value="DOGE">Dogecoin (DOGE)</option>
                <option value="LTC">Litecoin (LTC)</option>
                <option value="TON">TON (The Open Network)</option>
            </select>
            <br><br>
            <div id="usdt-network" style="display:none;">
                <label for="network">Select Network:</label>
                <select name="network" id="network">
                    <option value="ERC20">ERC20 (Ethereum)</option>
                    <option value="TRC20">TRC20 (Tron)</option>
                    <option value="BEP20">BEP20 (Binance Smart Chain)</option>
                </select>
            </div>
            <br>
            <button type="button" onclick="generateAddress()">Get Payment Address & QR Code</button>
        </form>

        <div id="result" class="qr-code-container" style="display:none;">
            <h2>Scan to Pay:</h2>
			<p>Copy or scan the QR code below to complete your transaction</p>
            <img id="qrCode" src="" alt="QR Code" />
			<input type="text" id="address" readonly style="width: 100%; padding: 8px; text-align: center;">
            <button id="copyBtn" onclick="copyAddress()">Copy Address</button>
            <h2>Transaction Info:</h2>
            <p id="transactionInfo" class="transaction-info"></p>
            <button class="go-back-btn" onclick="goBack()">Change Payment Gateway</button>
        </div>
    </div>
    <script>
        function toggleNetworkOptions() {
            var currency = document.getElementById('currency').value;
            var networkOptions = document.getElementById('usdt-network');
            if (currency === 'USDT') {
                networkOptions.style.display = 'block';
            } else {
                networkOptions.style.display = 'none';
            }
        }

function updateAmountMessage() {
    var amount = document.getElementById('amount').value;
    var currency = document.getElementById('currency').value;

    var messageElement = document.getElementById('transactionInfo');
    messageElement.innerHTML = '';  

    var newMessage = 
        "Send $" + amount + " to the address above.<br>" + 
        "You will be automatically redirected after the transaction is successful."
		;

    messageElement.innerHTML = newMessage;
}

        function generateAddress() {
            var currency = document.getElementById('currency').value;
            var amount = document.getElementById('amount').value;
            var network = document.getElementById('network') ? document.getElementById('network').value : '';

            var payload = {
                currency: currency,
                amount: amount,
                merchant: '4NYXDK-YIVIN8-YQ0X6K-1BBOU8',
                orderId: 'ORD-' + Date.now(),
                callbackUrl: 'https://example.com/callback',
                email: 'customer@example.com'
            };

            if (currency === 'USDT' && network) {
                payload.network = network;
            }

            fetch('https://api.oxapay.com/merchants/request/staticaddress', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(payload)
            })
            .then(response => response.json())
            .then(data => {
                if (data.result === 100) {
                    var address = data.address;
                    var qrCodeUrl = "https://api.qrserver.com/v1/create-qr-code/?data=" + encodeURIComponent(address) + "&size=300x300";
                    document.getElementById('address').value = address;
                    document.getElementById('qrCode').src = qrCodeUrl;
                    document.getElementById('result').style.display = 'block';

                    document.getElementById('cryptoForm').style.display = 'none';
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while generating the address.');
            });
        }

		function copyAddress() {
			var addressInput = document.getElementById('address');
			addressInput.select();
			addressInput.setSelectionRange(0, 99999); 

			navigator.clipboard.writeText(addressInput.value).then(function() {
				alert("Address copied to clipboard!");
			}).catch(function(error) {
				console.error('Error copying text: ', error);
			});
		}

        function goBack() {
            document.getElementById('result').style.display = 'none';
            document.getElementById('cryptoForm').style.display = 'block';
        }
    </script>
</body>
</html>