<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Access — Secure Login</title>
    <style>
        :root {
            --primary: #332f86;
            --accent: #0b5ed7;
            --bg: #f4f4f9;
            --text-dark: #222;
            --radius: 14px;
        }

        body {
            font-family: 'Segoe UI', Tahoma, sans-serif;
            background: var(--bg);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
        }

        .login-container {
            background: #fff;
            border-radius: var(--radius);
            box-shadow: 0 4px 10px rgba(0,0,0,0.08);
            padding: 2rem;
            width: 100%;
            max-width: 380px;
        }

        h2 {
            text-align: center;
            color: var(--primary);
            margin-bottom: 1.5rem;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        input[type="password"] {
            padding: 12px;
            font-size: 16px;
            border-radius: var(--radius);
            border: 1px solid #ccc;
            margin-bottom: 1rem;
            outline: none;
            transition: 0.2s;
        }

        input[type="password"]:focus {
            border-color: var(--accent);
            box-shadow: 0 0 4px rgba(11,94,215,0.3);
        }

        button {
            background: var(--accent);
            color: white;
            border: none;
            padding: 12px;
            border-radius: var(--radius);
            font-size: 16px;
            cursor: pointer;
            transition: 0.2s;
        }

        button:hover {
            background: #084fc5;
        }

        .error {
            color: red;
            text-align: center;
            font-size: 14px;
            margin-bottom: 10px;
        }

        @media (max-width: 480px) {
            .login-container {
                padding: 1.5rem;
                max-width: 100%;
            }

            h2 {
                font-size: 1.4rem;
            }

            button, input {
                font-size: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Enter Access Password</h2>

        @if ($errors->any())
            <div class="error">{{ $errors->first('password') }}</div>
        @endif

        <form method="POST" action="{{ url('/front-login/check') }}">
            @csrf
            <input type="password" name="password" placeholder="Enter Password" required>
            <button type="submit">Access Website</button>
        </form>
    </div>
</body>
</html>
