<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class FrontGateMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        // If session already has 'front_authenticated', allow access
        if (Session::get('front_authenticated')) {
            return $next($request);
        }

        // Allow access to front-login page and post route
        if ($request->is('front-login') || $request->is('front-login/check')) {
            return $next($request);
        }

        // Otherwise, redirect to the front login page
        return redirect('/front-login');
    }
}
